' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' Klasa Appointment jest uywana do reprezentacji rezerwacji, ktrych uytkownik moe dokonywa w Systemie Rezerwacji On-line.
''' </summary>
Public Class Appointment

#Region "Zmienne prywatne"

  Private _Id As Integer
  Private _UserName As String = String.Empty
  Private _UserEmailAddress As String = String.Empty
  Private _StartDate As DateTime = DateTime.MinValue
  Private _EndDate As DateTime = DateTime.MinValue
  Private _Comments As String = String.Empty
  Private _BookingObjectId As Integer = -1

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Pobiera lub ustawia identyfikator rezerwacji.
  ''' </summary>
  ''' <returns>Zwraca -1, gdy rezerwacja jest nowa i nie zostaa zapisana w bazie danych. Returns identyfikator of rezerwacji w bazie danych w przeciwnym razie.</returns>
  Public Property Id() As Integer
    Get
      Return _Id
    End Get
    Set(ByVal value As Integer)
      _Id = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia nazw uytkownika, ktry dokona tej rezerwacji.
  ''' </summary>
  Public Property UserName() As String
    Get
      Return _UserName
    End Get
    Set(ByVal value As String)
      _UserName = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia adres e-mail uytkownika, ktry dokona tej rezerwacji.
  ''' </summary>
  Public Property UserEmailAddress() As String
    Get
      Return _UserEmailAddress
    End Get
    Set(ByVal value As String)
      _UserEmailAddress = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia komentarz, ktry uytkownik doda dla tej rezerwacji.
  ''' </summary>
  Public Property Comments() As String
    Get
      Return _Comments
    End Get
    Set(ByVal value As String)
      _Comments = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia najwczeniejsz dat i czas dla tej rezerwacji.
  ''' </summary>
  Public Property StartDate() As DateTime
    Get
      Return _StartDate
    End Get
    Set(ByVal value As DateTime)
      _StartDate = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia najpniejsz dat i czas dla tej rezerwacji.
  ''' </summary>
  Public Property EndDate() As DateTime
    Get
      Return _EndDate
    End Get
    Set(ByVal value As DateTime)
      _EndDate = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia identyfikator obiektu rezerwacji, dla ktrego dokonano rezerwacji.
  ''' </summary>
  Public Property BookingObjectId() As Integer
    Get
      Return _BookingObjectId
    End Get
    Set(ByVal value As Integer)
      _BookingObjectId = value
    End Set
  End Property

#End Region

End Class
